#ifndef _WIN32_DCOM
#define _WIN32_DCOM
#endif

#include <windows.h>
#include <objbase.h>
#include <atlbase.h>
#include <iostream>
#include <wbemidl.h>
#include <comutil.h>


int main( int argc, char** argv )
{
	HRESULT hr = CoInitializeEx( NULL, COINIT_MULTITHREADED );
	if ( FAILED( hr ) )
	{
		std::cerr << "COM initialization failed" << std::endl;
		return -1;
	}

	// setup process-wide security context
	hr = CoInitializeSecurity( NULL, // we're not a server
							   -1, // we're not a server
							   NULL, // dito
							   NULL, // reserved
							   RPC_C_AUTHN_LEVEL_DEFAULT, // let DCOM decide
							   RPC_C_IMP_LEVEL_IMPERSONATE,
							   NULL,
							   EOAC_NONE,
							   NULL );
	if ( FAILED( hr ) )
	{
		std::cerr << "Security initialization failed" << std::endl;
		return -1;
	}

	int result = 0;
	// we're going to use CComPtr<>s, whose lifetime must end BEFORE CoUnitialize is called
	{
		// connect to WMI
		CComPtr< IWbemLocator > locator;
		hr = CoCreateInstance( CLSID_WbemAdministrativeLocator, NULL,
							CLSCTX_INPROC_SERVER,
							IID_IWbemLocator, reinterpret_cast< void** >( &locator ) );
		if ( FAILED( hr ) )
		{
			std::cerr << "Instantiation of IWbemLocator failed" << std::endl;
			return -1;
		}

		// connect to local service with current credentials
		CComPtr< IWbemServices > service;
		hr = locator->ConnectServer( L"root\\cimv2", NULL, NULL, NULL,
									 WBEM_FLAG_CONNECT_USE_MAX_WAIT,
									 NULL, NULL, &service );
		if ( SUCCEEDED( hr ) )
		{
			// execute a query
			CComPtr< IEnumWbemClassObject > enumerator;
			// you might want to use a more real life ip address here
			hr = service->ExecQuery( L"WQL", L"SELECT * FROM Win32_PingStatus WHERE Address=\"127.0.0.1\"",
								     WBEM_FLAG_FORWARD_ONLY | WBEM_FLAG_RETURN_IMMEDIATELY, NULL, &enumerator );
			if ( SUCCEEDED( hr ) )
			{
				CComPtr< IWbemClassObject > ping = NULL;
				ULONG retcnt;
				// wait for result to become available
				while ( ( hr = enumerator->Next( 1L, 1L, &ping, &retcnt ) ) == WBEM_S_TIMEDOUT );
				if ( SUCCEEDED( hr ) )
				{
					if ( retcnt > 0 )
					{
						// query returns a result
						_variant_t var_val;
						hr = ping->Get( L"StatusCode", 0, &var_val, NULL, NULL );
						if ( SUCCEEDED( hr ) )
						{
							int str = var_val;
							std::cout << "Ping status: " << str << std::endl;
						}
						else
						{
							std::cerr << "IWbemClassObject::Get failed" << std::endl;
							result = -1;
						}
					}
					else
					{
						std::cout << "Enumeration empty" << std::endl;
					}
				}
				else
				{
					std::cerr << "Error in iterating through enumeration" << std::cerr;
					result = -1;
				}
			}
			else
			{
				std::cerr << "Query failed" << std::endl;
				result = -1;
			}
		}
		else
		{
			std::cerr << "Couldn't connect to service" << std::endl;
			result = -1;
		}
	}
	CoUninitialize();

	return result;
}
